/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.gui.common.SCTConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ActivityImageLabel
extends JLabel {
    private int xPos = 15;
    private int yPos = 170;
    private int vGap = 20;
    private Object activeItem;
    private Vector items = new Vector();
    private Color defaultFGColor = SCTConstants.qdiDkGray;
    private Color focusFGColor = SCTConstants.qdiColor;

    public ActivityImageLabel() {
        this((ImageIcon)null);
    }

    public ActivityImageLabel(ImageIcon imageIcon) {
        super(imageIcon);
        this.initImageLabel();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private void initImageLabel() {
        this.setVerticalAlignment(1);
        this.setFont(new Font("Arial", 1, 11));
        if (this.items != null && this.items.size() > 0) {
            this.activeItem = this.items.firstElement();
        }
    }

    public Object getSelectedItem() {
        return this.activeItem;
    }

    public void selectItem(Object object) {
        if (object == null) {
            return;
        }
        if (this.items.size() > 0 && this.items.contains(object)) {
            this.activeItem = object;
            this.paintComponent(this.getGraphics());
        }
    }

    public void selectNextItem() {
        int n;
        int n2 = this.items.size();
        if (n2 > 0 && (n = this.items.indexOf(this.activeItem)) + 1 < n2) {
            this.activeItem = this.items.elementAt(n + 1);
            this.paintComponent(this.getGraphics());
        }
    }

    public void selectPreviousItem() {
        int n;
        int n2 = this.items.size();
        if (n2 > 0 && (n = this.items.indexOf(this.activeItem)) - 1 >= 0) {
            this.activeItem = this.items.elementAt(n - 1);
            this.paintComponent(this.getGraphics());
        }
    }

    public void addItem(Object object) {
        if (this.items.size() < 1) {
            this.items.addElement(object);
            if (this.items.size() > 0 && this.activeItem == null) {
                this.activeItem = this.items.firstElement();
            }
            this.paintComponent(this.getGraphics());
        }
    }

    public void removeItem(Object object) {
        this.items.removeElement(object);
        if (this.items.size() > 0) {
            if (object == this.activeItem) {
                this.activeItem = this.items.firstElement();
            }
        } else {
            this.activeItem = null;
        }
        this.paintComponent(this.getGraphics());
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.items.size() > 0) {
            int n = this.yPos;
            Enumeration enumeration = this.items.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e.equals(this.activeItem)) {
                    graphics.setColor(this.focusFGColor);
                } else {
                    graphics.setColor(this.defaultFGColor);
                }
                graphics.drawString((String)e, this.xPos, n);
                n += this.vGap;
            }
        }
    }

    public void setXYPosition(int n, int n2) {
        this.xPos = n;
        this.yPos = n2;
    }

    public void setVGap(int n) {
        this.vGap = n;
    }
}

